/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen;

import committee.nova.mods.avaritia.api.client.screen.BaseContainerScreen;
import committee.nova.mods.avaritia.common.menu.CompressorMenu;
import committee.nova.mods.avaritia.common.tile.CompressorTile;
import committee.nova.mods.avaritia.init.registry.ModTooltips;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class CompressorScreen
extends BaseContainerScreen<CompressorMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("avaritia", "textures/gui/compressor.png");
    private CompressorTile tile;

    public CompressorScreen(CompressorMenu container, Inventory inventory, Component title) {
        super(container, inventory, title, BACKGROUND, 176, 166, 256, 256);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.tile = this.getTileEntity();
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (mouseX > x + 63 && mouseX < x + 79 && mouseY > y + 35 && mouseY < y + 51) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (this.getMaterialCount() < 1) {
                tooltip.add(ModTooltips.EMPTY.color(ChatFormatting.WHITE).build());
            } else {
                if (this.hasMaterialStack()) {
                    tooltip.add(this.getMaterialStackDisplayName());
                }
                MutableComponent text = Component.m_237113_((String)(CompressorScreen.number(this.getMaterialCount()) + " / " + CompressorScreen.number(this.getMaterialsRequired())));
                tooltip.add(text);
            }
            guiGraphics.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
        }
    }

    protected void m_280003_(@NotNull GuiGraphics stack, int mouseX, int mouseY) {
        String title = this.m_96636_().getString();
        stack.m_280056_(this.f_96547_, title, this.f_97726_ / 2 - this.f_96547_.m_92895_(title) / 2, 6, 0x404040, false);
        stack.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 94, 0x404040, false);
    }

    protected void m_7286_(@NotNull GuiGraphics stack, float partialTicks, int mouseX, int mouseY) {
        this.renderDefaultBg(stack);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.hasRecipe()) {
            int i2;
            if (this.getMaterialCount() > 0 && this.getMaterialsRequired() > 0) {
                i2 = this.getMaterialBarScaled(16);
                stack.m_280218_(BACKGROUND, x + 63, y + 35, 176, 18, i2 + 1, 16);
            }
            if (this.getProgress() > 0 && this.getMaterialCount() >= this.getMaterialsRequired()) {
                i2 = this.getProgressBarScaled(22);
                stack.m_280218_(BACKGROUND, x + 89, y + 35, 176, 0, i2 + 1, 16);
            }
        }
    }

    private Component getMaterialStackDisplayName() {
        CompressorMenu container;
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().f_91073_;
        if (level != null && (tile = level.m_7702_((container = (CompressorMenu)this.m_6262_()).getBlockPos())) instanceof CompressorTile) {
            CompressorTile compressor = (CompressorTile)tile;
            ItemStack materialStack = compressor.getMaterialStack();
            return materialStack.m_41786_();
        }
        return Component.m_237113_((String)"");
    }

    private CompressorTile getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().f_91073_;
        if (level != null && (tile = level.m_7702_(((CompressorMenu)this.m_6262_()).getBlockPos())) instanceof CompressorTile) {
            CompressorTile compressor = (CompressorTile)tile;
            return compressor;
        }
        return null;
    }

    public boolean isEjecting() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.isEjecting();
    }

    public boolean hasRecipe() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.hasRecipe();
    }

    public boolean hasMaterialStack() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.hasMaterialStack();
    }

    public int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    public int getMaterialCount() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getMaterialCount();
    }

    public int getMaterialsRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getMaterialsRequired();
    }

    public int getTimeRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getTimeRequired();
    }

    public int getMaterialBarScaled(int pixels) {
        int i = Mth.m_14045_((int)this.getMaterialCount(), (int)0, (int)this.getMaterialsRequired());
        int j = this.getMaterialsRequired();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public int getProgressBarScaled(int pixels) {
        int i = Mth.m_14045_((int)this.getProgress(), (int)0, (int)this.getTimeRequired());
        int j = this.getTimeRequired();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }
}

